<?php
include 'connection.php'; // Include the connection file

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Check if the required parameters are provided
    if (isset($_POST['operation'])) {
        $operation = $_POST['operation'];

        if ($operation === 'fetch_user_profile') {
            // Fetch User Profile
            if (isset($_POST['email'])) {
                $email = $conn->real_escape_string($_POST['email']);

                $sql = "SELECT * FROM user_profile WHERE email = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("s", $email);
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows > 0) {
                    $data = $result->fetch_assoc();
                    echo json_encode(["success" => true, "data" => $data]);
                } else {
                    echo json_encode(["success" => false, "message" => "User not found"]);
                }

                $stmt->close();
            } else {
                echo json_encode(["success" => false, "message" => "Email parameter missing"]);
            }
        } elseif ($operation === 'fetch_test_results') {
            // Fetch Test Results
            if (isset($_POST['email'])) {
                $email = $conn->real_escape_string($_POST['email']);
        
                // Get the user's ID based on their email
                $userSql = "SELECT user_id FROM user_profile WHERE email = ?";
                $stmt = $conn->prepare($userSql);
                $stmt->bind_param("s", $email);
                $stmt->execute();
                $userResult = $stmt->get_result();
        
                if ($userResult->num_rows > 0) {
                    $user = $userResult->fetch_assoc();
                    $userId = $user['user_id'];
        
                    // Fetch all test results for the user including test ID and guest user name
                    $testSql = "
                        SELECT 
                            id, -- Include the test record ID
                            personality_type, 
                            title, 
                            test_date, 
                            extraversion_percentage, 
                            intuition_percentage, 
                            thinking_percentage, 
                            judging_percentage, 
                            introversion_percentage, 
                            sensing_percentage, 
                            perceiving_percentage, 
                            feeling_percentage, 
                            icon_url, 
                            guest_user_name
                        FROM test_results 
                        WHERE user_id = ? 
                        ORDER BY test_date DESC"; // Order results by most recent test date
                    $testStmt = $conn->prepare($testSql);
                    $testStmt->bind_param("i", $userId);
                    $testStmt->execute();
                    $testResult = $testStmt->get_result();
        
                    if ($testResult->num_rows > 0) {
                        $testData = [];
                        while ($row = $testResult->fetch_assoc()) {
                            $testData[] = $row;
                        }
        
                        echo json_encode(["success" => true, "data" => $testData]);
                    } else {
                        echo json_encode(["success" => false, "message" => "No test results found. Please take a test first."]);
                    }
        
                    $testStmt->close();
                } else {
                    echo json_encode(["success" => false, "message" => "User not found."]);
                }
        
                $stmt->close();
            } else {
                echo json_encode(["success" => false, "message" => "Email parameter missing."]);
            }
        } else {
            echo json_encode(["success" => false, "message" => "Invalid operation specified."]);
        }
    }
    
} 

$conn->close(); // Close the database connection
?>
